# CacheMe
# Author: K0NxT3D
# Description: Python Based Browser Cache Cleaner & Backup Utility.
# cacheme.py

import os
import shutil
import platform
import browser_cookie3

# Define local directory for cache storage
cache_backup_dir = os.path.expanduser('~/browser_cache_backup')

# Ensure the backup directory exists
if not os.path.exists(cache_backup_dir):
    os.makedirs(cache_backup_dir)

# Function to gather browser cache files
def gather_cache(browser_name, cache_paths):
    print(f"Gathering cache for {browser_name}...")
    browser_dir = os.path.join(cache_backup_dir, browser_name)
    
    if not os.path.exists(browser_dir):
        os.makedirs(browser_dir)
    
    for path in cache_paths:
        if os.path.exists(path):
            shutil.copytree(path, browser_dir, dirs_exist_ok=True)
            print(f"Cached files for {browser_name} copied to {browser_dir}")
        else:
            print(f"No cache found for {browser_name} at {path}")

# Function to clear browser cache
def clear_cache(cache_paths):
    for path in cache_paths:
        if os.path.exists(path):
            shutil.rmtree(path)
            print(f"Cleared cache at {path}")

# Cache directories for different browsers (Linux paths)
def get_browser_cache_paths():
    cache_paths = {
        "chromium": [
            os.path.expanduser('~/.cache/chromium/Default/Cache'),
            os.path.expanduser('~/.config/chromium/Default/Service Worker/CacheStorage')
        ],
        "firefox": [
            os.path.expanduser('~/.cache/mozilla/firefox'),
            os.path.expanduser('~/.mozilla/firefox')
        ],
        "edge": [
            os.path.expanduser('~/.config/microsoft-edge/Default/Cache'),
        ],
        "opera": [
            os.path.expanduser('~/.config/opera/Cache'),
        ],
        # Safari cache paths will depend on macOS
        "safari": [
            os.path.expanduser('~/Library/Caches/com.apple.Safari'),
        ]
    }
    return cache_paths

# Main function to gather and clear cache for all browsers
def gather_and_clear_all_browsers():
    cache_paths = get_browser_cache_paths()
    
    for browser_name, paths in cache_paths.items():
        gather_cache(browser_name, paths)
        clear_cache(paths)

# Run the cache gathering and clearing process
if __name__ == "__main__":
    gather_and_clear_all_browsers()

