<?php
/* 
 * DSX - R. Seaverns 2022
 * Version DS7 1.2.4 January 2022
 * DSX Black Hat CMS
 * Generate Content and Files Based on Keywords
 * and SEO Rich Content.
 * ---------------------
 * The Hatcher
 * R. Seaverns 2019
 * Generate Keyword Named Pages and Sitemap.xml Then Submit To Google, Bing, Yahoo and MSN.
 * Originally From - H₂SEO Black Hat Content Management System
 * Repurposed for DSX 2022 - R Seaverns.
 *
 * file: hatcher.php
*/

// Hatcher Configuration Settings
$url = "default_url"; //
$urls = file('keywords.txt');
$SiteIndex = '../index.php';
$IndexTemplate = 'index_template.php';
$sitemap = fopen("../sitemap.xml", "w") or die("Unable to open file!"); // Sitemap.xml File
$chicken = fopen("keywords.txt", "r+"); // Keyword List
$yolk = file_get_contents("index_template.php"); // Cloned Template
$nest = ("../"); // Create Files In Root (Per Default Plugin Path)

// Random File Last Mod Date
$Timestamp = date('m/d/Y ', time());
$start = 1;
$end = 60 * 60 * 24;
$LastMod = mt_rand($start, $end);
$Spoof = date('h:i:s a', $LastMod);
$TimeOutput = $Timestamp.$Spoof;
// End Hatcher Config

// Clone index.php to Root & Keywords to Keyword Pages
unlink($SiteIndex); // Remove Intital Setup index.php
copy($IndexTemplate, $SiteIndex); // Replace with New index.php

while ($egg = stream_get_line($chicken, 1024 * 1024, "\n"))
 {
  $chick = $nest.$egg.".php"; // Set Filetype (.php)
  touch($chick);
  file_put_contents($chick,$yolk);
 }
fclose($chicken);

// Generate Sitemap In Root
$chicken = fopen("keywords.txt", "r+"); // Keyword List

fwrite($sitemap,'<?xml version="1.0" encoding="UTF-8"?>'."\r\n");
fwrite($sitemap,'<!-- DSX XML Sitemap Generator 2.1 -->'."\r\n");
fwrite($sitemap,'<!-- Date: '.$TimeOutput.' -->'."\r\n");
fwrite($sitemap,'<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"'."\r\n");
fwrite($sitemap,'        xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"'."\r\n");
fwrite($sitemap,'        xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9'."\r\n");
fwrite($sitemap,'        http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd">'."\r\n");
fwrite($sitemap,'  <url>'."\r\n");
fwrite($sitemap,'    <loc>'.$url.'</loc>'."\r\n");
fwrite($sitemap,'    <lastmod>'.date("Y-m-d H:i:s").'</lastmod>'."\r\n");
fwrite($sitemap,'    <changefreq>daily</changefreq>'."\r\n");
fwrite($sitemap,'    <priority>1.0</priority>'."\r\n");
fwrite($sitemap,'  </url>'."\r\n");

while ($link = stream_get_line($chicken, 1024 * 1024, "\n"))
 {
// Random File Last Mod Date - Loop
$Timestamp = date('m/d/Y ', time());
$start = 1;
$end = 60 * 60 * 24;
$LastMod = mt_rand($start, $end);
$Spoof = date('h:i:s a', $LastMod);
$TimeOutput = $Timestamp.$Spoof;
fwrite($sitemap,'  <url>'."\r\n");
fwrite($sitemap,'    <loc>'.$url.$link.'.php</loc>'."\r\n");
fwrite($sitemap,'    <lastmod>'.$TimeOutput.'</lastmod>'."\r\n");
fwrite($sitemap,'    <changefreq>daily</changefreq>'."\r\n");
fwrite($sitemap,'    <priority>0.8</priority>'."\r\n");
fwrite($sitemap,'  </url>'."\r\n");
}
fwrite($sitemap,'</urlset> ');
fclose($sitemap);

// Create Sitemap.xml.gz In Root
$zip = new ZipArchive();
if ($zip->open('../sitemap.xml.gz', ZipArchive::OVERWRITE) === TRUE)
{
    $zip->addFile('../sitemap.xml');
    $zip->close();
}
if ($zip->open('../sitemap.xml.gz', ZipArchive::CREATE) === TRUE)
{
    $zip->addFile('../sitemap.xml');
    $zip->close();
}

// Submit Sitemap List - Multiple Sitemaps Allowed
$sitemaps = array(
"$url.sitemap.xml",
"$url.sitemap.xml.gz" // Last Line In Array - No Comma
//! - NOTE: Changed with php 8.0 trailing commas are okay now..
);

// Ping Googlebot and Bingbot - Submit The Sitemaps
function Submit($url){
  $ch = curl_init($url);
  curl_setopt($ch, CURLOPT_HEADER, 0);
  curl_exec($ch);
  $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  curl_close($ch);
  return $httpCode;
}

function SubmitSiteMap($url) {
  $returnCode = Submit($url);
  if ($returnCode != 200) {
    echo "Error $returnCode: $url <br>";
  } else {
    echo "Submitted $returnCode: $url <br>";
  }
}

// Set the Submit URL(s) to the Search Engine(s) You Want To Submit To.
foreach ($sitemaps as $sitemapUrl) {
  $sitemapUrl = htmlentities($sitemapUrl);
  
  //Google  
  $url = "http://www.google.com/webmasters/sitemaps/ping?sitemap=".$sitemapUrl;
  SubmitSiteMap($url);
  
  //Bing / MSN / Yahoo
  $url = "http://www.bing.com/webmaster/ping.aspx?siteMap=".$sitemapUrl;
  SubmitSiteMap($url);

}

header("Refresh:2; url=../index.php");
