<style>
body {
    background-color:#0c0c0c;
    font-family:Roboto;
    color:#fff;
    line-height:200%;
    letter-spacing:4px;

}

#Focus {
    width:50%;
    margin:auto;
    margin-top:20px;
    border:4px solid #a00000;
    border-radius:8px;
    box-shadow:0px 0px 2px #000 inset;
}

#setupButton {
    height:50px;
    width:200px;
    background-color:#000;
    color:#fff;
    border:4px solid #a00000;
    border-radius:8px;
    font-weight:900;
}

#setupButton:hover {
    background-color:#0c0c0c;
    color:Green;
    border:4px solid Green;
}

.pulsate {
    -webkit-animation: pulsate 3s ease-out;
    -webkit-animation-iteration-count: infinite; 
    opacity: 0.3;
}

@-webkit-keyframes pulsate {
    0% { 
        opacity: 0.3;
    }
    50% { 
        opacity: 1.0;
    }
    100% { 
        opacity: 0.3;
    }
}
</style>
<?php
if(isset($_POST["submit"])){
// Installation Complete Output.
echo '<div id="Focus" style="color:Green !important;" align="center">';
echo '<h1>DSX Installation</h1>';
// Set Up Config
$DATABASE_HOST = htmlspecialchars($_POST["remotehost"]);
$DATABASE_USER = htmlspecialchars($_POST["dbusername"]);
$DATABASE_PASS = htmlspecialchars($_POST["dbuserpass"]);
$DATABASE_NAME = htmlspecialchars($_POST["dbname"]);
$SITEURL = htmlspecialchars($_POST["siteurl"]);

/////////////////////////////////////
// Create Database
$conn = new mysqli($DATABASE_HOST, $DATABASE_USER, $DATABASE_PASS);
if ($conn->connect_error) {
  die("Connection Failure: " . $conn->connect_error."<br>");
}

$sql = "CREATE DATABASE IF NOT EXISTS $DATABASE_NAME CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;";
if ($conn->query($sql) === TRUE) {
  echo "$DATABASE_NAME Database Created Successfully!<br>";
} else {
  echo "Error Creating $DATABASE_NAME - " . $conn->error."<br>";
}

$conn->close();

/////////////////////////////////////
// Create Keywords Table
$conn = new mysqli($DATABASE_HOST, $DATABASE_USER, $DATABASE_PASS, $DATABASE_NAME);
if ($conn->connect_error) {
  die("Connection Failure: " . $conn->connect_error."<br>");
}

$sql = "CREATE TABLE IF NOT EXISTS KEYWORDS (
id INT(1) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
KEYWORD VARCHAR(128) NOT NULL)"; // SAFE MAX Limit

if ($conn->query($sql) === TRUE) {
  echo "Table: Keywords Created Successfully!<br>";
} else {
  echo "Error Creating Keywords Table: " . $conn->error."<br>";
}

////////////////////////////////////
// Insert Keywords
// Keywords Input File
$KeywordFile = fopen('admin/keywords.txt','r');
while (!feof($KeywordFile)) 
{
    $GetData = fgets($KeywordFile);
    $StripLine = explode("\n",$GetData);	
	list($KEYWORD) = $StripLine;
	$query = "insert into KEYWORDS (KEYWORD) values('".$KEYWORD."')";
	mysqli_query($conn,$query);
}

fclose($KeywordFile);
$conn->close();

/////////////////////////////////////
// Create Content Table
$conn = new mysqli($DATABASE_HOST, $DATABASE_USER, $DATABASE_PASS, $DATABASE_NAME);
if ($conn->connect_error) {
  die("Connection Failure: " . $conn->connect_error."<br>");
}

$sql = "CREATE TABLE IF NOT EXISTS CONTENT (
id INT(1) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
CONTENT VARCHAR(4096) NOT NULL)"; // MAX Limit

if ($conn->query($sql) === TRUE) {
  echo "Table: Content Created Successfully!<br>";
} else {
  echo "Error Creating Content Table: " . $conn->error."<br>";
}

////////////////////////////////////
// Insert Content
// Content Input File
$ContentFile = fopen('admin/content.txt','r');
while (!feof($ContentFile)) 
{
	$GetData = fgets($ContentFile);
	$StripLine = explode("\n",$GetData);
	
	list($CONTENT) = $StripLine;
	$query = "insert into CONTENT (CONTENT) values('".$CONTENT."')";
	mysqli_query($conn,$query);
}

fclose($ContentFile);
$conn->close();

/////////////////////////////////////
// Clean Up Any Empty Keyword Data
$conn = new mysqli($DATABASE_HOST, $DATABASE_USER, $DATABASE_PASS, $DATABASE_NAME);
if ($conn->connect_error) {
  die("Connection Failure: " . $conn->connect_error."<br>");
}

$sql = "DELETE FROM `KEYWORDS` WHERE `KEYWORDS`.`KEYWORD` = \"\";";
	mysqli_query($conn,$query);

if ($conn->query($sql) === TRUE) {
  echo "Keywords Cleaned Successfully!<br>";
} else {
  echo "Error Cleaning Keywords Table: " . $conn->error."<br>";
}

$conn->close();

/////////////////////////////////////
// Clean Up Any Empty Content Data
$conn = new mysqli($DATABASE_HOST, $DATABASE_USER, $DATABASE_PASS, $DATABASE_NAME);
if ($conn->connect_error) {
  die("Connection Failure: " . $conn->connect_error."<br>");
}

$sql = "DELETE FROM `CONTENT` WHERE `CONTENT`.`CONTENT` = \"\";";
	mysqli_query($conn,$query);

if ($conn->query($sql) === TRUE) {
  echo "Content Cleaned Successfully!<br>";
} else {
  echo "Error Cleaning Content Table: " . $conn->error."<br>";
}

$conn->close();

/////////////////////////////////////////////////////
// Edit The Default config.php
$ConfigFile = 'admin/config.php';
$defaultSettings = array(
"default_dbhost",
"default_dbuser",
"default_dbpass",
"default_dbname",
);

$newSettings = array(
$DATABASE_HOST,
$DATABASE_USER,
$DATABASE_PASS,
$DATABASE_NAME,
);

$ReadConfig=file_get_contents($ConfigFile);
$writefunction=str_replace($defaultSettings, $newSettings,$ReadConfig);
file_put_contents($ConfigFile, $writefunction);

/////////////////////////////////////////////////////
// Edit The Default hatcher.php
$HatchFile = 'admin/hatcher.php';
$defaultUrl = 'default_url';
$newUrl = "$SITEURL";

$ReadHatcher=file_get_contents($HatchFile);
$writefunction=str_replace($defaultUrl, $newUrl,$ReadHatcher);
file_put_contents($HatchFile, $writefunction);

echo '<h2>Setup Complete! - Populating WebSite</h2>';
header("Refresh:2; url=admin/hatcher.php");
echo '</div>';
} else{ ?>
<div align="center" style="border:4px solid #333;border-radius:8px;">
<img src="files/images/setup-banner.png">
<table>
 <tr>
  <td style="padding:15px;">
    <h1>Setup Instructions:</h1>
     <p><b>Database Host: </b><em>Generally "localhost".</em><br>
        <b>Database User: </b><em>Your MySQL User Name.</em><br>
        <b>Database Password: </b><em>Your MySQL User Password.</em><br>
        <b>Database Name: </b><em>Create New Database Named.</em><br>
        <b>WebSite URL: </b><em>https://www.mysite.com/</em></p>
        <h2 align="center" style="color:orange; background-color:#333;border-radius:8px;">
        If You Do Not Know What You're Doing<br>Do Not Proceed!</h2>
  </td>
  <td style="padding:15px;">
   <h1>Database Setup</h1>
    <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method ="post">
      <p><pre>Database Host:<input type="text" name="remotehost"></pre></p>
      <p><pre>Database User:<input type="text" name="dbusername"></pre></p>
      <p><pre>Database Pass:<input type="password" name="dbuserpass"></pre></p>
      <p><pre>Database Name:<input type="text" name="dbname"></pre></p>
      <p><pre>WebSite URL:  <input type="text" name="siteurl"></pre></p>
      <div align="center"><input class="pulsate" id="setupButton" type="submit" value="Begin DSX Installation" name="submit"></div>
    </form>
   </td>
  </tr>
</table>
</div>
<?php } ?>
