# Title: DocR - Log Reader
# Version: 1.0.4 Release
# Author: K0NxT3D
# Description: For Reading Large Log Files.
# Author URL: http://k0nxt3d.seaverns.com/

import tkinter as tk
from tkinter import filedialog, simpledialog
import os
import time
import curses
from pyfiglet import Figlet

def clear_screen():
    os.system('cls' if os.name == 'nt' else 'clear')

def display_splash():
    figlet = Figlet(font='doom')
    splash_text = figlet.renderText('Doc.R')
    title_text = "  Doc.R"
    version_text = "  Version 1.0"
    author_text = "  By: K0NxT3D"
    
    clear_screen()
    print(splash_text)
    print(title_text)
    print(version_text)
    print(author_text)
    time.sleep(4)
    clear_screen()

clear_screen()
display_splash()


def select_file():
    root = tk.Tk()
    root.withdraw()  # Hide the root window
    file_path = filedialog.askopenfilename(title="Select a log file", filetypes=[("All files", "*.*"), ("Log files", "*.log")])
    return file_path

def get_lines_to_display():
    root = tk.Tk()
    root.withdraw()
    while True:
        lines = simpledialog.askinteger("Lines to Display", "Enter number of lines to display at once:", minvalue=1)
        if lines is not None:
            return lines

def get_order():
    root = tk.Tk()
    root.withdraw()
    order = simpledialog.askstring("Display Order", "Enter 'asc' for ascending or 'desc' for descending:")
    while order not in ['asc', 'desc']:
        order = simpledialog.askstring("Invalid Input", "Please enter 'asc' for ascending or 'desc' for descending:")
    return order

def display_log(stdscr, file_path, lines_to_display, order):
    curses.curs_set(0)  # Hide cursor
    stdscr.clear()      # Clear screen

    with open(file_path, 'r') as file:
        lines = file.readlines()

    # Adjust order
    if order == 'desc':
        lines = list(reversed(lines))

    start = 0
    total_lines = len(lines)

    while True:
        stdscr.clear()
        max_y, max_x = stdscr.getmaxyx()  # Get terminal size

        # Display the current chunk of lines
        end = min(start + lines_to_display, total_lines)
        for i in range(start, end):
            # Ensure we don't exceed the width of the terminal
            line = lines[i][:max_x - 1]  # Truncate to fit width, leave space for newline
            stdscr.addstr(i - start, 0, line)

        # Provide instructions at the bottom
        stdscr.addstr(min(lines_to_display, max_y - 1), 0, "Press Up/Down to Scroll, Enter to Load More, 'q' to Quit.")
        stdscr.refresh()

        key = stdscr.getch()

        if key == curses.KEY_UP:
            start = max(0, start - 1)  # Scroll up one line
        elif key == curses.KEY_DOWN:
            start = min(total_lines - 1, start + 1)  # Scroll down one line
        elif key == curses.KEY_ENTER or key in [10, 13]:  # Enter key
            start = min(total_lines, start + lines_to_display)  # Load more lines
        elif key == ord('q'):  # 'q' to quit
            break

if __name__ == "__main__":
    log_file = select_file()
    if not log_file or not os.path.isfile(log_file):
        print("No valid file selected. Exiting.")
    else:
        lines_to_display = get_lines_to_display()
        order = get_order()
        curses.wrapper(display_log, log_file, lines_to_display, order)

