# ENKI — Visual Binary Transmutation Engine

Author: Rob Seaverns (K0NxT3D)  
Version: 1.2  
Status: Experimental / Research  
Language: Go  
Platform: Linux, Windows  

---

## Overview

ENKI is a deterministic visual encoding engine written in Go. It converts arbitrary binary data into symbolic pixel representations, renders those symbols into structured image frames, and encodes the frames into a standard MP4 video container using FFmpeg.

The process is fully reversible. Every bit of the original input file is preserved and can be reconstructed exactly from the generated animation.

ENKI is not designed for efficiency or secrecy. It is designed for fidelity, structure, and experimentation at the boundary between data and visual form.

Conceptually, the project draws inspiration from ancient Sumerian systems of knowledge preservation, where information was stored using symbol, geometry, and repetition rather than linear text.

---

## What ENKI Is

- A binary-to-visual transformation engine  
- A deterministic and reversible encoding system  
- A research and archival experiment  
- A tool for symbolic data representation  

## What ENKI Is Not

- Not encryption  
- Not compression  
- Not obfuscation  
- Not optimized for storage or speed  

---

## Encoding Pipeline

1. Input file is read sequentially, byte by byte  
2. Each byte is expanded into 8 bits (MSB-first)  
3. Bits are mapped to fixed pixel colors  
4. Pixels are written into a vertical filmstrip buffer  
5. The filmstrip is segmented into square frames  
6. Frames are encoded into an MP4 container via FFmpeg  

---

## Decoding Pipeline

1. A frame is extracted from the MP4 file  
2. Pixel color values are sampled  
3. Colors are mapped back to binary values  
4. Bits are reassembled into bytes  
5. The original file is reconstructed bit-for-bit  

---

## Color Encoding Scheme

| Symbol | Meaning | RGB |
|------:|---------|-----|
| 0 | Bit Zero | 0, 0, 0 |
| 1 | Bit One | 255, 255, 255 |
| Void | Background | #111111 |

---

## Usage

### Encode a File

```bash
./enki encode input.bin
```

### Decode a File

```bash
./enki decode animation.mp4 output.bin
```

### Windows

```powershell
enki.exe encode input.bin
enki.exe decode animation.mp4 output.bin
```

---

## Requirements

- Go 1.20 or newer  
- FFmpeg installed and available in PATH  
- Linux or Windows environment  

---

## Design Constraints

- Deterministic output (no randomness)  
- Fixed frame geometry  
- MSB-first bit ordering  
- Pixel-perfect reversibility  

---

## Release History

### v1.2
- Stable MP4 encoding pipeline  
- Reliable decode path  
- Clean separation of encode/decode logic  

### v1.0
- Initial proof-of-concept release  
- PNG-based intermediate artifacts  

---

## Disclaimer

ENKI is experimental research software. No guarantees are made regarding performance, long-term archival stability, or fitness for any particular purpose. Use at your own risk.

---

## Attribution

ENKI is part of the K0NxT3D toolchain.
