#!/bin/bash
# CacheMe
# Author: K0NxT3D
# Description: Bash Based System Memory Cleaner.
# cacheme.sh

# Function to clear system caches
clear_caches() {
    echo "Clearing system caches..."
    sync; echo 3 | sudo tee /proc/sys/vm/drop_caches
}

# Function to clear swap memory
clear_swap() {
    echo "Clearing swap memory..."
    sudo swapoff -a && sudo swapon -a
}

# Function to clear apt cache (if using apt)
clear_apt_cache() {
    echo "Clearing apt cache..."
    sudo apt-get clean
}

# Function to clear thumbnail cache
clear_thumbnail_cache() {
    echo "Clearing thumbnail cache..."
    rm -rf ~/.cache/thumbnails/*
}

# Function to clear system logs (be careful with this)
clear_logs() {
    echo "Clearing system logs..."
    sudo journalctl --vacuum-time=1d
}

# Function to clear temporary files
clear_temp_files() {
    echo "Clearing temporary files..."
    sudo rm -rf /tmp/* ~/.cache/*
}

# Main function
main() {
    clear_caches
    clear_swap
    clear_apt_cache
    clear_thumbnail_cache
    clear_logs
    clear_temp_files
    echo "Cleanup complete!"
}

# Run the main function
main

