<?php
// Load configuration file
require 'config.php';

$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 10; // Default to 10 rows per page
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1; // Default to page 1
$offset = ($page - 1) * $limit;

// Handle keyword entry
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['submit_keywords'])) {
        $keywords = array_map('trim', explode(',', $_POST['keywords']));
        foreach ($keywords as $keyword) {
            if (!empty($keyword)) {
                $keyword = strtolower($keyword);

                // Check if the keyword already exists
                $check_stmt = $conn->prepare("SELECT COUNT(*) FROM Search_Terms WHERE Keywords = ?");
                $check_stmt->bind_param("s", $keyword);
                $check_stmt->execute();
                $check_stmt->bind_result($count);
                $check_stmt->fetch();
                $check_stmt->close();

                // Insert if the keyword does not exist
                if ($count == 0) {
                    $stmt = $conn->prepare("INSERT INTO Search_Terms (Keywords) VALUES (?)");
                    $stmt->bind_param("s", $keyword);
                    $stmt->execute();
                    $stmt->close();
                }
            }
        }
    } elseif (isset($_POST['search'])) {
        $selected_keywords = $_POST['keywords'];
        if (!empty($selected_keywords)) {
            $search_terms = implode(' ', $selected_keywords);
            header("Location: search.php?query=" . urlencode($search_terms));
            exit();
        }
    }
}


// Fetch total number of keywords
$result_total = $conn->query("SELECT COUNT(*) AS total FROM Search_Terms");
$total_keywords = $result_total->fetch_assoc()['total'];

// Fetch keywords for display with pagination
$result = $conn->query("SELECT * FROM Search_Terms ORDER BY Keywords ASC LIMIT $limit OFFSET $offset");
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" type="text/css" href="style.css" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Oswald&display=swap" rel="stylesheet">
    <link rel="icon" type="image/x-icon" href="k_search_logo.png">
    <title>Keyword Search Utility - K0NxT3D</title>
    <script>
        function sortTable(n) {
            var table, rows, switching, i, x, y, shouldSwitch, dir, switchCount = 0;
            table = document.getElementById("keywordTable");
            switching = true;
            dir = "asc";
            while (switching) {
                switching = false;
                rows = table.rows;
                for (i = 1; i < (rows.length - 1); i++) {
                    shouldSwitch = false;
                    x = rows[i].getElementsByTagName("TD")[n];
                    y = rows[i + 1].getElementsByTagName("TD")[n];
                    if (dir == "asc") {
                        if (x.innerHTML.toLowerCase() > y.innerHTML.toLowerCase()) {
                            shouldSwitch = true;
                            break;
                        }
                    } else if (dir == "desc") {
                        if (x.innerHTML.toLowerCase() < y.innerHTML.toLowerCase()) {
                            shouldSwitch = true;
                            break;
                        }
                    }
                }
                if (shouldSwitch) {
                    rows[i].parentNode.insertBefore(rows[i + 1], rows[i]);
                    switching = true;
                    switchCount++;
                } else {
                    if (switchCount === 0 && dir === "asc") {
                        dir = "desc";
                        switching = true;
                    }
                }
            }
        }
    </script>
</head>
<body>
    <img src="k_search_logo.png" height="64px" width="64px">
    <h1 style="margin-top: -50px; margin-left: 48px;">eyword Search</h1>
        <form method="get" action="index.php">
        <label for="limit">Keywords Per Page:</label>
        <select id="limit" name="limit" onchange="this.form.submit()">
            <option value="10" <?php echo $limit == 10 ? 'selected' : ''; ?>>10</option>
            <option value="20" <?php echo $limit == 20 ? 'selected' : ''; ?>>20</option>
            <option value="30" <?php echo $limit == 30 ? 'selected' : ''; ?>>30</option>
            <option value="50" <?php echo $limit == 50 ? 'selected' : ''; ?>>50</option>
        </select>
    </form>

    <form method="post">
        <label for="keywords">Enter Keywords (comma-separated):</label>
        <input type="text" id="keywords" name="keywords">
        <button type="submit" name="submit_keywords" style="margin-left: 5px;">Submit Keywords</button>
    </form>
    <br>
    <form method="post">
        <table id="keywordTable">
            <thead>
                <tr>
                    <th onclick="sortTable(0)">Select</th>
                    <th onclick="sortTable(1)">Keywords - Search Terms</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = $result->fetch_assoc()) { ?>
                    <tr>
                        <td><input type="checkbox" name="keywords[]" value="<?php echo htmlspecialchars($row['Keywords']); ?>"></td>
                        <td><?php echo htmlspecialchars($row['Keywords']); ?></td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
        <p><button type="submit" name="search">Search Results</button></p>
    </form>
    <div class="pagination">
        <?php
        $total_pages = ceil($total_keywords / $limit);

        // First and Previous Page
        if ($page > 1) {
            echo "<a href='index.php?page=1&limit=$limit'>&lt;&lt; First Page</a> ";
            echo "<a href='index.php?page=" . ($page - 1) . "&limit=$limit'>&lt; Previous Page</a> ";
        } else {
            echo "<span>&lt;&lt; First Page</span> ";
            echo "<span>&lt; Previous Page</span> ";
        }

        // Page numbers
        for ($i = 1; $i <= $total_pages; $i++) {
            $active = $i == $page ? 'style="font-weight: bold;"' : '';
            echo "<a href='index.php?page=$i&limit=$limit' $active>$i</a> ";
        }

        // Next and Last Page
        if ($page < $total_pages) {
            echo "<a href='index.php?page=" . ($page + 1) . "&limit=$limit'>Next Page &gt;</a> ";
            echo "<a href='index.php?page=$total_pages&limit=$limit'>Last Page &gt;&gt;</a> ";
        } else {
            echo "<span>Next Page &gt;</span> ";
            echo "<span>Last Page &gt;&gt;</span> ";
        }
        ?>
    </div>
    <center>
    <form method="get" action="index.php">
        <label for="limit">Results Per Page:</label>
        <select id="limit" name="limit" onchange="this.form.submit()">
            <option value="10" <?php echo $limit == 10 ? 'selected' : ''; ?>>10</option>
            <option value="20" <?php echo $limit == 20 ? 'selected' : ''; ?>>20</option>
            <option value="30" <?php echo $limit == 30 ? 'selected' : ''; ?>>30</option>
            <option value="50" <?php echo $limit == 50 ? 'selected' : ''; ?>>50</option>
        </select>
    </form>
    </center>
</body>
</html>
<?php
$conn->close();
?>

