<?php
<?php
/*
Senya 2.0 - MySQL Database Editor
By: K0NxT3D
URL: http://www.seaverns.com/
File: display_table.php
    Display Current MySQL Table Data

    Sleek and easy to use MySQL Database Editor.
    Enter Server Configuration Manually Or Automatically From File

        File: saved_hosts.txt
        Examples Included.
*/
session_start();

if (!isset($_SESSION['host'], $_SESSION['user'], $_SESSION['password'], $_SESSION['database'])) {
    header('Location: index.php');
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" type="text/css" href="style.css" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Oswald&display=swap" rel="stylesheet">
    <link rel="icon" type="image/x-icon" href="logo.png">
    <title>Senya 2.0</title>
</head>
<body>
    <div class="display_table_data">
 <h2><a id="senya_title_display" class="senya_title" href=".">Main</a></h2>
<?php
if (isset($_GET['table'])) {
    $table = $_GET['table'];

    $conn = new mysqli($_SESSION['host'], $_SESSION['user'], $_SESSION['password'], $_SESSION['database']);

    if ($conn->connect_error) {
        die("<p class=\"senya_alert_n\">Connection Failed: " . $conn->connect_error). "</p>";
    }

    $sql = "SELECT * FROM $table";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        // Fetch the primary key
        $primaryKeyResult = $conn->query("SHOW KEYS FROM $table WHERE Key_name = 'PRIMARY'");
        $primaryKey = $primaryKeyResult->fetch_assoc()['Column_name'];

        echo "<h2>Data in table: $table</h2>";
        echo "<form method='post' action='update.php'>";
        echo "<table class=\"senya_edit_table\"><tr>";

        $fields = $result->fetch_fields();
        foreach ($fields as $field) {
            echo "<th>" . $field->name . "</th>";
        }
        echo "</tr>";

        while($row = $result->fetch_assoc()) {
            echo "<tr>";
            foreach ($fields as $field) {
                $value = htmlspecialchars($row[$field->name], ENT_QUOTES, 'UTF-8');
                if ($field->name == $primaryKey) {
                    echo "<td><input type='hidden' name='" . $field->name . "[]' value='" . $value . "'>$value</td>";
                } else {
                    echo "<td><input type='text' name='" . $field->name . "[]' value='" . $value . "'></td>";
                }
            }
            echo "</tr>";
        }
        echo "</table>";
        echo "<input type='hidden' name='table' value='$table'>";
        echo "<input style=\"margin-top:20px !important;\" id=\"senya_update\" type='submit' value='Update Data'>";
        echo "</form>";
    } else {
        echo "<p class=\"senya_alert_n\">No Data Found.</p>";
    }

    $conn->close();
}
?>
 </div>
</body>
</html>

