<?php
/*
Senya 2.0 - MySQL Database Editor
By: K0NxT3D
URL: http://www.seaverns.com/
File: index.php
    Do Stuff & Look Good Doing It.

    Sleek and easy to use MySQL Database Editor.
    Enter Server Configuration Manually Or Automatically From File

        File: saved_hosts.txt
        Examples Included.
*/
session_start();

function read_hosts_file($file) {
    $hosts = [];
    if (file_exists($file)) {
        $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        foreach ($lines as $line) {
            $parts = str_getcsv($line);
            if (count($parts) == 5) {
                $hosts[] = $parts;
            }
        }
    }
    return $hosts;
}

$hosts_file = 'saved_hosts.txt';
$hosts = read_hosts_file($hosts_file);

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_FILES['csv_file'])) {
    $file_tmp = $_FILES['csv_file']['tmp_name'];
    if (($handle = fopen($file_tmp, 'r')) !== FALSE) {
        while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
            if (count($data) == 5) {
                $hosts[] = $data;
            }
        }
        fclose($handle);
        // Save unique hosts
        $unique_hosts = array_unique($hosts, SORT_REGULAR);
        $fp = fopen($hosts_file, 'w');
        foreach ($unique_hosts as $host) {
            fputcsv($fp, $host);
        }
        fclose($fp);
        $hosts = $unique_hosts;
    }
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['select_host'])) {
    $selected_host = explode('|', $_POST['select_host']);
    $_SESSION['host'] = $selected_host[1];
    $_SESSION['user'] = $selected_host[2];
    $_SESSION['password'] = $selected_host[3];
    $_SESSION['database'] = $selected_host[4];
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" type="text/css" href="style.css" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Oswald&display=swap" rel="stylesheet">
    <link rel="icon" type="image/x-icon" href="logo.png">
    <title>Senya 2.0</title>
</head>
<body>
   <h1><a href="." class="senya_title change-language" data-ru="Сеня 2.0">Senya 2.0</a></h1></div>
<input type="checkbox" id="toggle" class="toggle-checkbox">
<label for="toggle" class="toggle-label">Expand&nbsp 🔼 &nbsp&nbsp🔽</label>
   <div class="manual_login_form">
    <h2>Server Credentials:</h2>
    <form method="post" action="?id=1#results" enctype="multipart/form-data">
        <label for="host">MySQL Host:</label>
        <input class="senya_form_input" type="text" id="host" name="host" value="<?php echo isset($_SESSION['host']) ? $_SESSION['host'] : ''; ?>" required><br><br>
        <label for="user">MySQL User:</label>
        <input type="text" id="user" name="user" value="<?php echo isset($_SESSION['user']) ? $_SESSION['user'] : ''; ?>" required><br><br>
        <label for="password">MySQL Password:</label>
        <input type="password" id="password" name="password" value="<?php echo isset($_SESSION['password']) ? $_SESSION['password'] : ''; ?>" required><br><br>
        <label for="database">Database Name:</label>
        <input type="text" id="database" name="database" value="<?php echo isset($_SESSION['database']) ? $_SESSION['database'] : ''; ?>" required><br><br>
        <input type="submit" id="connect" value="Connect">
    </form>
   </div>

<h1></h1>
<input type="checkbox" id="toggle2" class="toggle-checkbox2">
<label for="toggle2" class="toggle-label2">Expand&nbsp 🔼 &nbsp&nbsp🔽</label>
   <div class="dropdown_login_form">
    <form method="post" action="" enctype="multipart/form-data">
       <h2> <label style="text-align: left !important;" for="csv_file">Import CSV:</label></h2>
        <input type="file" id="csv_file" name="csv_file" accept=".csv"><br><br>
        <p><input id="csv_file" type="submit" value="Import CSV"></p>
    </form>

    <form method="post" action="?id=1#results">
        <label for="select_host">Select Saved Host:</label>
        <select id="select_host" name="select_host">
            <option value="">--Select--</option>
            <?php
            foreach ($hosts as $host) {
                echo "<option value='" . implode('|', $host) . "'>" . $host[0] . "</option>";
            }
            ?>
        </select><br><br>
        <input id="use_host" type="submit" value="Use Selected Host">
    </form>
   </div>
<?php
if (isset($_SESSION['host'], $_SESSION['user'], $_SESSION['password'], $_SESSION['database'])) {
    $conn = new mysqli($_SESSION['host'], $_SESSION['user'], $_SESSION['password'], $_SESSION['database']);

    if ($conn->connect_error) {
        die("<p class=\"senya_alert_n\">Connection failed: " . $conn->connect_error) . "</p>";
    }
    echo "<p class=\"senya_alert_y\">Connected Successfully.</p>";

    $sql = "SHOW TABLES";
    $result = $conn->query($sql);

    if ($result->num_rows > 0) {
        echo '   <div class="display_table_data">';
        echo "<h2 id=\"results\">Database Tables:</h2>";
        echo "<ul>";
        while($row = $result->fetch_array()) {
            echo "<li><a class=\"senya_table_data\" href='display_table.php?table=" . $row[0] . "'>" . $row[0] . "</a></li>";
        }
        echo "</ul>";
    } else {
        echo "<p class=\"senya_alert_n\">No Tables Found.</p>";
    }

    $conn->close();
}
        echo '</div>';
?>
</body>
</html>

