<?php
/*
Senya 2.0 - MySQL Database Editor
By: K0NxT3D
URL: http://www.seaverns.com/
File: update.php
    Update MySQL Table Data

    Sleek and easy to use MySQL Database Editor.
    Enter Server Configuration Manually Or Automatically From File

        File: saved_hosts.txt
        Examples Included.
*/
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" type="text/css" href="style.css" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Oswald&display=swap" rel="stylesheet">
    <link rel="icon" type="image/x-icon" href="logo.png">
    <title>Senya 2.0</title>
</head>
<body>
   <h1 class="senya_title">Senya 2.0</h1>
    <div class="edit_table_data">
<?php
session_start();

if (!isset($_SESSION['host'], $_SESSION['user'], $_SESSION['password'], $_SESSION['database'])) {
    header('Location: index.php');
    exit();
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $table = $_POST['table'];

    $conn = new mysqli($_SESSION['host'], $_SESSION['user'], $_SESSION['password'], $_SESSION['database']);

    if ($conn->connect_error) {
        die("<p class=\"senya_alert_n\">Connection Failed: " . $conn->connect_error) . "</p>";
    }

    // Fetch table columns to identify the primary key
    $result = $conn->query("SHOW KEYS FROM $table WHERE Key_name = 'PRIMARY'");
    $primaryKey = $result->fetch_assoc()['Column_name'];

    foreach ($_POST[$primaryKey] as $index => $primaryKeyValue) {
        $setClauses = [];
        foreach ($_POST as $field => $values) {
            if ($field != 'table' && $field != $primaryKey) {
                $setClauses[] = "$field = '" . $conn->real_escape_string($values[$index]) . "'";
            }
        }
        $setClause = implode(", ", $setClauses);

        $sql = "UPDATE $table SET $setClause WHERE $primaryKey = '$primaryKeyValue'";
        if ($conn->query($sql) !== TRUE) {
            echo "<p class=\"senya_alert_n\">Error Updating Data: " . $conn->error . "</p>";
        }
    }

    echo "<p class=\"senya_alert_y\">Records Updated.";

    $conn->close();
}

header("Refresh:0; url=index.php");

?>
    </div>
 </body>
</html>
