## ⚙️ `build.sh`

#!/bin/bash
# ===============================================
# Holocron 2.0.1 Build Script
# Builds Linux and/or Windows binaries for Go app
# ===============================================

clear

APP_NAME="holocron"
SRC_FILE="holocron.go"
DB_FILE="asn.db"
README_FILE="README.txt"
HTML_FILE="index.html"
TIMESTAMP=$(date +%Y%m%d_%H%M%S)
ZIP_NAME="holocron_release_${TIMESTAMP}.zip"

echo "==============================================="
echo " Build The Holocron"
echo "==============================================="
echo "1) Build Linux binary"
echo "2) Build Windows binary"
echo "3) Build both"
echo "-----------------------------------------------"
read -p "Choose option [1-3]: " choice

# Ensure Go installed
if ! command -v go >/dev/null 2>&1; then
    echo "Error: Go is not installed or not in PATH."
    echo "Install from https://go.dev/dl"
    exit 1
fi

# Build directories
mkdir -p build

case "$choice" in
1)
    echo "[+] Building Linux binary..."
    GOOS=linux GOARCH=amd64 go build -o build/${APP_NAME}_linux ${SRC_FILE}
    BUILT_FILES=("build/${APP_NAME}_linux")
    ;;
2)
    echo "[+] Building Windows binary..."
    GOOS=windows GOARCH=amd64 go build -o build/${APP_NAME}_windows.exe ${SRC_FILE}
    BUILT_FILES=("build/${APP_NAME}_win.exe")
    ;;
3)
    echo "[+] Building Linux binary..."
    GOOS=linux GOARCH=amd64 go build -o build/${APP_NAME} ${SRC_FILE}
    echo "[+] Building Windows binary..."
    GOOS=windows GOARCH=amd64 go build -o build/${APP_NAME}.exe ${SRC_FILE}
    BUILT_FILES=("build/${APP_NAME}" "build/${APP_NAME}.exe")
    ;;
*)
    echo "Invalid selection. Exiting."
    exit 1
    ;;
esac

# Confirm zip option
echo "-----------------------------------------------"
read -p "Do you want to create a zip distributable bundle? (y/n): " zip_choice

if [[ "$zip_choice" =~ ^[Yy]$ ]]; then
    # Check for zip utility
    if ! command -v zip >/dev/null 2>&1; then
        echo "Error: 'zip' command not found. Install it first (apt install zip)."
        exit 1
    fi

    echo "[+] Creating ${ZIP_NAME}..."
    zip -j "${ZIP_NAME}" "${README_FILE}" "${HTML_FILE}" "${DB_FILE}" "${BUILT_FILES[@]}"
    echo "[+] Done. Created: ${ZIP_NAME}"
else
    echo "[*] Build(s) completed without zipping."
    echo "Files located in ./build/"
fi

echo "-----------------------------------------------"
echo "Build process complete."

