# ReconX — Domain Reconnaissance Spyglass

![Status](https://img.shields.io/badge/status-active-brightgreen)
![Python](https://img.shields.io/badge/python-3.12+-blue)
![Platform](https://img.shields.io/badge/platform-Linux%20%7C%20RPi-lightgrey)
![License](https://img.shields.io/badge/license-Private-red)

ReconX is a powerful, dark‑themed, multi‑layer reconnaissance tool for domains.
ReconX 2.0 expands capabilities with:

- 🔥 Dark-theme ASCII banners
- 🔥 Wordlist-based brute-force subdomain scanning
- 🔥 HTML report generator (dark-mode themed)
- 🔥 Multi-domain batch scanning
- 🔥 DNS, SSL, and port-scanning intelligence
- 🔥 Raspberry Pi–optimized scanning engine

Designed for penetration testers, security researchers, and network analysts.

---

## 📌 Features

### 🌐 Subdomain Enumeration
- Built‑in list of common subdomains
- Brute-force mode using any wordlist
- Fast threaded resolver with fallback DNS servers
- Errors handled gracefully (NXDOMAIN, timeouts, etc.)

### 🔒 SSL Certificate Analysis
- Retrieves CN, Issuer, Validity dates
- ISO8601 timestamps
- Handles expired or misconfigured certificates

### 🔍 Port Scanning
- Multi-threaded TCP scanner
- Default target ports:
21, 22, 23, 25, 53, 80, 110, 143,
443, 587, 3306, 8080


### 📝 Reporting
- Text reports saved automatically
- Optional HTML report:
- Responsive dark theme
- Tables, sections, headers
- Clean markup for archiving & professional documentation

### 📦 Batch Scanning
- Scan multiple domains from a list
- Batch brute mode supported
- Fully automated & timestamped

---

## ⚙️ Requirements

ReconX runs on **Python 3.12+**, tested on:

- Ubuntu 24.04 LTS
- Raspberry Pi OS / Ubuntu Server ARM
- Standard Linux distributions

### Install dependencies (requirements.txt):

dnspython>=2.6.1
termcolor>=2.4.0
colorama>=0.4.6
requests>=2.32.3
beautifulsoup4>=4.12.3
html5lib>=1.1

### Optional:

tqdm>=4.66.4
rich>=13.7.1
Jinja2>=3.1.4


---

## 🛠 Installation

git clone https://github.com/your-repo/ReconX.git
cd ReconX

python3 -m venv venv
source venv/bin/activate

pip install -r requirements.txt
python3 ReconX.py


### 🚀 Usage

ReconX is fully interactive.

1) Quick Scan (single domain)
python3 ReconX.py
> 1
> example.com

2) Single Domain + Brute Force
python3 ReconX.py
> 2
> example.com
> /path/to/wordlist.txt

3) Batch Scan (multiple domains)
python3 ReconX.py
> 3
> domains.txt

4) Batch + Brute Mode
python3 ReconX.py
> 4
> domains.txt
> wordlist.txt

📄 Report Output

All reports are stored in:

./reconx_reports/

Text Report Example:
reconx_example_com_20251207_192948.txt

HTML Report Example:
reconx_example_com_20251207_192948.html


