===========================================
              ☠️  SKULLY  ☠️
        Exploit & Vulnerability Tester
===========================================

Overview
--------
SkUlLY is a CLI-based exploit and vulnerability testing utility
designed for red-team scanning, service probing, and automated
form-based exploitation attempts.

All data is stored in:
X-Files/{url}.db

This tool is designed for high-obfuscation scenarios and supports:
- torsocks routing
- full User-Agent rotation (1,132 unique browser/device signatures)


Why SkUlLY Is Extremely Difficult to Block
-------------------------------------------
A normal scanner can often be detected because requests come from:

- predictable IP ranges
- consistent browser signatures
- recognizable request patterns

SkUlLY avoids these issues by using *two* layers of obfuscation:

1. Tor-routed Traffic via torsocks
   Every request may originate from a different Tor circuit.
   Blocking SkUlLY requires blocking entire sections of Tor exit
   nodes, which most targets are unwilling to do.

2. User-Agent Rotation (1,132 unique strings)
   Each request impersonates a different browser, OS, crawler,
   bot, or device. Combined with Tor rotation, every request
   appears to originate from a unique device somewhere on Earth.

This combination defeats:
- pattern-based detection
- WAF heuristics
- behavioral fingerprinting
- common scanner-detection systems


Features
--------
- Full URL parsing & host extraction
- Sends a curated set of exploit payload templates
- Rotates User-Agents for every request
- Tor-compatible (torsocks)
- Parses returned HTML and stores discovered links in SQLite
- Auto-generated database per target
- Silent handling of duplicate entries
- Basic scanner output displayed directly in terminal


Usage
-----
Run (Terminal):

    torsocks ./skully

You will be prompted for a target URL:

    Target URL (e.g., http://www.example.com/):

SkUlLY will then:
- fire a sequence of exploit templates 
- apply randomized User-Agent rotation 
- store discovered links in the database 


Technical Notes
---------------
Original File: skully.py 
Author: K0NxT3D 
Version: 1.0 
Output Directory: X-Files 
Database Engine: SQLite3 
Scanner Type: CLI-based exploit tester 


Legal Notice
------------
SkUlLY is a security research tool.

Use only on systems you own or are legally authorized to test.
Unauthorized scanning may violate federal and international laws.


