<?php
/*
Title: 🌀 WebSocket Chat Script
Author: K0NxT3D
Description: Simple Web Sockets Client - Server Chat Script.
File: client.php
URL: http://k0nxt3d.seaverns.com/
Use:
    On Server Host Run : php server.php
    On Client Host Open client.php.
        Make sure The $host matches in client.php:
        Line 107: const ws = new WebSocket('ws://127.0.0.1:6969');
*/
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>🌀 WebSocket Chat Script</title>
<style>
body {
    margin: 0;
    background-color: #0c0c0c;
    font-family: Impact;
    color: #fff;
}

.container {
    display: block;
    padding-top: 5px;
    padding-bottom: 5px;
    border: 4px solid #990000;
    border-radius: 4px;
    box-shadow: 1px 1px 2px #000;
}

p.title {
    letter-spacing: 4px;
    font-size: 32px;
    margin: 0;
}

#chat {
    margin-top: 5px;
    text-align: left !important;
    border: 2px solid #990000;
    border-radius: 4px;
    width: 420px;
    height: 350px;
    overflow-y: scroll;
    background: linear-gradient(45deg, #000000 0%, #000033 45%);
    padding: 10px;
    opacity: 0.7;
}

#chat::-webkit-scrollbar {
    width: 12px;
}

#chat::-webkit-scrollbar-track {
    background-color: #000033;
}

#chat::-webkit-scrollbar-thumb {
    background: #990000;
    border-radius: 2px;
}

#chat::-webkit-scrollbar-thumb:hover {
    background: #0c0c0c;
    border: 1px solid #990000;
    border-radius: 2px;
}

#message {
    width: 400px;
    background-color: #000033;
}

.message {
    margin: 10px 0;
}

input#message.chat-input {
    color: #fff;
    font-family: Impact;
    font-size: 18px;
    margin: 5px;
    height: 25px;
    padding: 10px;
    width: 420px;
    border: 2px solid #990000;
    border-radius: 4px;
    box-shadow: 0px 0px 2px #000033;
}
</style>
</head>
<body>
    <div class="container" align="center">
        <p class="title">🌀 WebSocket Chat Script</p>
        <div id="chat"></div>
        <input id="message" type="text" class="chat-input" placeholder="Type a message..."/>
    </div>
    <script>
        // Ensure This Matches The Server / Host Address.
        const ws = new WebSocket('ws://127.0.0.1:6969');

        ws.onmessage = function(event) {
            const chat = document.getElementById('chat');
            chat.innerHTML += `<div class="message">${event.data}</div>`;
            chat.scrollTop = chat.scrollHeight;
        };

        document.getElementById('message').addEventListener('keypress', function(event) {
            if (event.key === 'Enter') {
                sendMessage();
            }
        });

        function sendMessage() {
            const messageInput = document.getElementById('message');
            const message = messageInput.value;
            if (message) {
                ws.send(message);
                messageInput.value = '';
            }
        }
    </script>
</body>
</html>
